/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::  Module      :   Module Definitions for MPC5xx based modules
::  Copyright   :   (C)2002-2009 Woodward
::  Platform(s) :   MPC5xx
::  Dependants  :   None
::
::-----------------------------------------------------------------------------------------------------------
::
::  API
::  Provides definitions of the various modules supported by the MPC5xx platform
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file  ModuleDefn.h
 \brief The Module Definition describes factory preset data preset at time of manufacture.*/

#ifndef __MODULEDEFN_MPC5XX_H
#define __MODULEDEFN_MPC5XX_H

/*---- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include <typedefn.h>

/*---- DEFINES --------------------------------------------------------------------------------------------*/

/*==== PCM_MODULE Major Version 0x08 ============================== */

/* PCM HWREV_MINOR */
#define SDU1_HWREV_MINOR            0
#define SDU2_HWREV_MINOR            1
#define SDU3E_HWREV_MINOR           2
#define SDU3I_HWREV_MINOR           3
#define PRE_DV_HWREV_MINOR          4
#define PRE_DV_PROD_HWREV_MINOR     5

#define DV_DEV_HWREV_MINOR          6
#define DV_DEV_KNOCK_HWREV_MINOR    7
#define DV_PROD_HWREV_MINOR         8
#define DV_PROD_FULL_SYS_MINOR      8   /* Same as DV_PROD_HWREV_MINOR */
#define DV_PROD_ENG_ONLY_MINOR      9

#define PV_DEV_FULL_SYS_MINOR       10
#define PV_PROD_FULL_SYS_MINOR      11
#define PV_PROD_ENG_ONLY_MINOR      12
#define PV_DEV_KNOCK_HWREV_MINOR    13

#define PV_K2_DEV_FULL_SYS_MINOR        14
#define PV_K2_DEV_KNOCK_HWREV_MINOR     15
#define PV_K2_PROD_FULL_SYS_MINOR       16
#define PV_K2_PROD_ENG_ONLY_MINOR       17
#define PCM_K2_DEV_FSO2_HWREV_MINOR     18

#define PCM_M_DEV_FS_HWREV_MINOR        19
#define PCM_M_DEV_FSO2_HWREV_MINOR      20
#define PCM_M_PROD_FS_HWREV_MINOR       21
#define PCM_M_PROD_EO_HWREV_MINOR       22

#define VCM_K2_DEV_HWREV_MINOR          23
#define VCM_K2_PROD_HWREV_MINOR         24
#define VCM_M_DEV_HWREV_MINOR           25
#define VCM_M_PROD_HWREV_MINOR          26

/*==== PCM03_MODULE Major Version 0x0A ============================== */
#define PCM03_0301_BASE_ENGINE				0x01    /* K2 processors */
#define PCM03_0302_FULL_SYSTEM				0x02
#define PCM03_0303_FULL_SYSTEM_O2			0x03
#define PCM03_0304_FS2_CALMEM_LOGMEM		0x04
#define PCM03_0305_FS3_CALMEM_LOGMEM		0x05
#define PCM03_0306_FS2_CALMEM_LOGMEM_MKICS	0x06
#define PCM03_0307_FS3_CALMEM_LOGMEM_MKICS	0x07
#define PCM03_0308M_BASE_ENGINE				0x08    /* M processors */
#define PCM03_0309M_FULL_SYSTEM				0x09
#define PCM03_0310M_FULL_SYSTEM_O2			0x0a
#define PCM03_0311M_FS2_CALMEM_LOGMEM		0x0b
#define PCM03_0312M_FS3_CALMEM_LOGMEM		0x0c
#define PCM03_0313M_FS2_CALMEM_LOGMEM_MKICS	0x0d
#define PCM03_0314M_FS3_CALMEM_LOGMEM_MKICS	0x0e
#define PCM03_0315M_FS3       	            0x0f
#define PCM03_0316M_FS3_CALMEM_LOGMEM       0x10
#define PCM03_0317M_FS3_CALMEM_LOGMEM_MKICS 0x11

/*==== #define VCM03_MODULE                        0x0B */    /* VCM03 */
#define VCM03_0301_FS						0x01    /* Rev. K2 processors */
#define VCM03_0302_FS_CALMEM_LOGMEM			0x02
#define VCM03_0303M_FS						0x03    /* Rev. M processors */
#define VCM03_0304M_FS_CALMEM_LOGMEM		0x04

/*==== #define PCMHD_MODULE                        0x0C */   /* PCMHD */

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: PCM RACE
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*==== #define PCMRACE_MODULE                      0x0D */   /* PCM128-RACE */
/* PCMRACE_MODULE HWREV_MINOR */
#define SDU2_PCMRACE                        0x00 /* SDU2 */
#define PRE_DV_PCMRACE_HI_VOL               0x01 /* Pre-DV High Volume Production */
#define PRE_DV_PCMRACE_LO_VOL               0x02 /* Pre-DV Low Volume Production */
#define PRE_DV_PCMRACE_KNK_DEV_LO_VOL       0x03 /* Pre-DV Knock Dev with Low Volume Production Emulation */
#define PRE_DV_PCMRACE_KNK_DEV_HI_VOL       0x04 /* Pre-DV Knock Dev with High Volume Production Emulation */
#define DV_PCMRACE_HI_VOL                   0x05 /* DV High Volume Production */
#define DV_PCMRACE_LO_VOL                   0x06 /* DV Low Volume Production */
#define DV_PCMRACE_KNK_DEV_LO_VOL           0x07 /* DV Knock Dev with Low Volume Production Emulation */
#define DV_PCMRACE_KNK_DEV_HI_VOL           0x08 /* DV Knock Dev with High Volume Production Emulation */
#define PV_PCMRACE_HI_VOL                   0x09 /* PV High Volume Production */
#define PV_PCMRACE_LO_VOL                   0x0A /* PV Low Volume Production */
#define PV_PCMRACE_KNK_DEV_LO_VOL           0x0B /* PV Knock Dev with Low Volume Production Emulation */
#define PV_PCMRACE_KNK_DEV_HI_VOL           0x0C /* PV Knock Dev with High Volume Production Emulation */

#define MY05_PCMRACE_HI_VOL                 0x0D /* MY05 High Volume Production */
#define MY05_PCMRACE_LO_VOL                 0x0E /* MY05 Low Volume Production */
#define MY05_PCMRACE_KNK_DEV_LO_VOL         0x0F /* MY05 Knock Dev with Low Volume Production Emulation */
#define MY05_PCMRACE_KNK_DEV_HI_VOL         0x10 /* MY05 Knock Dev with High Volume Production Emulation */

#define MY06_PCMRACE_HI_VOL                 0x11 /* MY06 High Volume Production */
#define MY06_PCMRACE_LO_VOL                 0x12 /* MY06 Low Volume Production */
#define MY06_PCMRACE_KNK_DEV_LO_VOL         0x13 /* MY06 Knock Dev with Low Volume Production Emulation */
#define MY06_PCMRACE_KNK_DEV_HI_VOL         0x14 /* MY06 Knock Dev with High Volume Production Emulation */

/* Changes backed out, Module does not exist at the time of writing */
/* But spot reserved */
#define MY08_PCMRACE_HI_VOL            		0x15 /* MY08 High Volume Production */
#define MY08_PCMRACE_LO_VOL            		0x16 /* MY08 Low Volume Production */
#define MY08_PCMRACE_KNK_DEV_LO_VOL    		0x17 /* MY08 Knock Dev with Low Volume Production Emulation */
#define MY08_PCMRACE_KNK_DEV_HI_VOL    		0x18 /* MY08 Knock Dev with High Volume Production Emulation */

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: ISDL 555 Core
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
#define ISDL_MODULE                         0x0E    /* Legacy Name */
/*==== #define ISDL_555_MODULE                     0x0E */
#define SDU_555_ISDL                        0x00

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: ISDL 565 Core
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*==== #define ISDL_565_MODULE                     0x0F */

/* ISDL_MODULE HWREV_MINOR */
#define SDU_565_ISDL                        0x00

#define PRE_DV_INSERVICE_FLASH              0x01
#define PRE_DV_INSERVICE_FLASHLESS          0x02
#define PRE_DV_SMARTCABLE_FLASH             0x03
#define PRE_DV_SMARTCABLE_FLASHLESS         0x04

#define DV_INSERVICE_FLASH                  0x05
#define DV_INSERVICE_FLASHLESS              0x06
#define DV_SMARTCABLE_FLASH                 0x07
#define DV_SMARTCABLE_FLASHLESS             0x08

#define PV_INSERVICE_FLASH                  0x09
#define PV_INSERVICE_FLASHLESS              0x0A
#define PV_SMARTCABLE_FLASH                 0x0B
#define PV_SMARTCABLE_FLASHLESS             0x0C

#define MY05_INSERVICE_FLASH                0x0D
#define MY05_INSERVICE_FLASHLESS            0x0E
#define MY05_SMARTCABLE_FLASH               0x0F
#define MY05_SMARTCABLE_FLASHLESS           0x10

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: ECM48 563 Core
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*==== #define ECM48_MODULE_HWMAJ                  0x13    */
#define ECM48_0701_PREDV                    0x00
#define ECM48_0702_PREDV             		0x01
#define ECM48_0701_PREDV2                   0x02
#define ECM48_0702_PREDV2            		0x03
#define ECM48_0701_PREDV3                   0x04
#define ECM48_0703_PREDV3                   0x05
#define ECM48_0703_EQUIV_RESVD              0x06 /* 0703 Equivalent reserved for future */
#define ECM48_0806_HWMIN                    0x07 /* 0703 For DAF Only (Hboot) */

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: AIM 565 Core
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*==== #define AIM_MODULE_HWMAJ                    0x14 */   
#define AIM_MODULE_SDU_PROTO_HWMIN          0x00	/* Includes compensations for current sense track errors */
#define AIM_MODULE_PROTO_V2_HWMIN           0x01	/* Shunt feed tracks fixed */

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: FIRE48 Series
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*==== #define FIRE48_MODULE_HWMAJ                 0x15    */
#define FIRE48_MODULE_HWMIN_CCM_V1          0x00
#define FIRE48_MODULE_HWMIN_SIM_V1          0x01
#define GCM48_MODULE_HWMIN_0801_V2          0x02  /* Name change GCM = General Control Module, 0801 = CCM, V2=DV */
#define GCM48_MODULE_HWMIN_0802_V2          0x03  /* Name change GCM = General Control Module, 0802 = SIM, V2=DV */
/* If you add new HWMIN, update ModuleCfg_FIRE48Module_IsCCM() */	

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: TVM48 Series
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*==== #define TVM48_MODULE_HWMAJ                 0x16    */
#define TVM48_MODULE_HWMIN_TVM_V1          0x00	
#define TVM48_MODULE_HWMIN_HLA_V1          0x01	
#define TVM48_MODULE_HWMIN_MII_V1          0x02	
#define HCM48_MODULE_HWMIN_0801_V2         0x03	/* Name change HCM = Hydraulic Control Module, 0801 = TVM, V2=? */
#define HCM48_MODULE_HWMIN_0802_V2         0x04	/* Name change HCM = Hydraulic Control Module, 0802 = HLA, V2=? */
#define HCM48_MODULE_HWMIN_0803_V2         0x05	/* Name change HCM = Hydraulic Control Module, 0803 = MII, V2=? */
/* If you add new HWMIN, update ModuleCfg_TVM48Module_IsTVM()
                                ModuleCfg_TVM48Module_IsHLA()
                                ModuleCfg_TVM48Module_IsMII() */

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: ECM
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*==== #define ECM_MODULE                      9 */
/* ECM HWREV_MINOR */
#define PRE_DV_ECM_DEV_HWREV_MINOR      0
#define PRE_DV_ECM_PROD_HWREV_MINOR     1
#define PRE_DV_ECM_DEV_K2_HWREV_MINOR   2
#define PRE_DV_ECM_PROD_K2_HWREV_MINOR  3
#define DV_ECM_DEV_HWREV_MINOR          4
#define DV_ECM_PROD_HWREV_MINOR         5

#define ECM_M_DEV_HWREV_MINOR           6
#define ECM_M_PROD_HWREV_MINOR          7

/* ECM_0202_ added ECUP protection diode, no software impact */
#define ECM_0203_DGCNK_DGCAM_CALMEM     0x08    /* DEV */
#define ECM_0203_DGCNK_DGCAM            0x09    /* PROD */
#define ECM_0203M_DGCNK_DGCAM_CALMEM    0x0a    /* DEV Rev. M */
#define ECM_0203M_DGCNK_DGCAM           0x0b    /* PROD Rev. M */

#define ECM0701                         0x0C
#define ECM0701_KNKDEV                  0x0D
#define ECM0702                         0x0E
#define ECM0702_KNKDEV                  0x0F
#define ECM0703                         0x10
#define ECM0703_KNKDEV                  0x11
#define ECM0704                         0x12
#define ECM0705                         0x13
#define ECM0705_KNKDEV                  0x14


/*---- TYPEDEF --------------------------------------------------------------------------------------------*/

/*---- FUNCTION PROTOTYPES --------------------------------------------------------------------------------*/

#endif /* __MODULEDEFN_MPC5XX_H */

/*---- END OF FILE ----------------------------------------------------------------------------------------*/

